<?php

declare(strict_types=1);

namespace Shopify\Webhooks;

/**
 * Contains a list of known webhook topics.
 *
 * For an up-to-date list of topics, you can visit
 * https://shopify.dev/docs/api/admin-graphql/latest/enums/webhooksubscriptiontopic
 */
final class Topics
{
    public const APP_PURCHASES_ONE_TIME_UPDATE = 'APP_PURCHASES_ONE_TIME_UPDATE';
    public const APP_SUBSCRIPTIONS_APPROACHING_CAPPED_AMOUNT = 'APP_SUBSCRIPTIONS_APPROACHING_CAPPED_AMOUNT';
    public const APP_SUBSCRIPTIONS_UPDATE = 'APP_SUBSCRIPTIONS_UPDATE';
    public const APP_UNINSTALLED = 'APP_UNINSTALLED';
    public const ATTRIBUTED_SESSIONS_FIRST = 'ATTRIBUTED_SESSIONS_FIRST';
    public const ATTRIBUTED_SESSIONS_LAST = 'ATTRIBUTED_SESSIONS_LAST';
    public const AUDIT_EVENTS_ADMIN_API_ACTIVITY = 'AUDIT_EVENTS_ADMIN_API_ACTIVITY';
    public const BULK_OPERATIONS_FINISH = 'BULK_OPERATIONS_FINISH';
    public const ATTRIBUTION_RISK = 'ATTRIBUTION_RISK';
    public const CARTS_CREATE = 'CARTS_CREATE';
    public const CARTS_UPDATE = 'CARTS_UPDATE';
    public const CHANNELS_DELETE = 'CHANNELS_DELETE';
    public const CHECKOUTS_CREATE = 'CHECKOUTS_CREATE';
    public const CHECKOUTS_DELETE = 'CHECKOUTS_DELETE';
    public const CHECKOUTS_UPDATE = 'CHECKOUTS_UPDATE';
    public const COLLECTIONS_CREATE = 'COLLECTIONS_CREATE';
    public const COLLECTIONS_DELETE = 'COLLECTIONS_DELETE';
    public const COLLECTIONS_UPDATE = 'COLLECTIONS_UPDATE';
    public const COLLECTION_LISTINGS_ADD = 'COLLECTION_LISTINGS_ADD';
    public const COLLECTION_LISTINGS_REMOVE = 'COLLECTION_LISTINGS_REMOVE';
    public const COLLECTION_LISTINGS_UPDATE = 'COLLECTION_LISTINGS_UPDATE';
    public const COLLECTION_PUBLICATIONS_CREATE = 'COLLECTION_PUBLICATIONS_CREATE';
    public const COLLECTION_PUBLICATIONS_DELETE = 'COLLECTION_PUBLICATIONS_DELETE';
    public const COLLECTION_PUBLICATIONS_UPDATE = 'COLLECTION_PUBLICATIONS_UPDATE';
    public const COMPANIES_CREATE = 'COMPANIES_CREATE';
    public const COMPANIES_DELETE = 'COMPANIES_DELETE';
    public const COMPANIES_UPDATE = 'COMPANIES_UPDATE';
    public const COMPANY_CONTACTS_CREATE = 'COMPANY_CONTACTS_CREATE';
    public const COMPANY_CONTACTS_DELETE = 'COMPANY_CONTACTS_DELETE';
    public const COMPANY_CONTACTS_UPDATE = 'COMPANY_CONTACTS_UPDATE';
    public const COMPANY_CONTACT_ROLES_ASSIGN = 'COMPANY_CONTACT_ROLES_ASSIGN';
    public const COMPANY_CONTACT_ROLES_REVOKE = 'COMPANY_CONTACT_ROLES_REVOKE';
    public const COMPANY_LOCATIONS_CREATE = 'COMPANY_LOCATIONS_CREATE';
    public const COMPANY_LOCATIONS_DELETE = 'COMPANY_LOCATIONS_DELETE';
    public const COMPANY_LOCATIONS_UPDATE = 'COMPANY_LOCATIONS_UPDATE';
    public const CUSTOMERS_CREATE = 'CUSTOMERS_CREATE';
    public const CUSTOMERS_DELETE = 'CUSTOMERS_DELETE';
    public const CUSTOMERS_DISABLE = 'CUSTOMERS_DISABLE';
    public const CUSTOMERS_EMAIL_MARKETING_CONSENT_UPDATE = 'CUSTOMERS_EMAIL_MARKETING_CONSENT_UPDATE';
    public const CUSTOMERS_ENABLE = 'CUSTOMERS_ENABLE';
    public const CUSTOMERS_MARKETING_CONSENT_UPDATE = 'CUSTOMERS_MARKETING_CONSENT_UPDATE';
    public const CUSTOMERS_MERGE = 'CUSTOMERS_MERGE';
    public const CUSTOMERS_UPDATE = 'CUSTOMERS_UPDATE';
    public const CUSTOMER_ACCOUNT_SETTINGS_UPDATE = 'CUSTOMER_ACCOUNT_SETTINGS_UPDATE';
    public const CUSTOMER_GROUPS_CREATE = 'CUSTOMER_GROUPS_CREATE';
    public const CUSTOMER_GROUPS_DELETE = 'CUSTOMER_GROUPS_DELETE';
    public const CUSTOMER_GROUPS_UPDATE = 'CUSTOMER_GROUPS_UPDATE';
    public const CUSTOMER_PAYMENT_METHODS_CREATE = 'CUSTOMER_PAYMENT_METHODS_CREATE';
    public const CUSTOMER_PAYMENT_METHODS_REVOKE = 'CUSTOMER_PAYMENT_METHODS_REVOKE';
    public const CUSTOMER_PAYMENT_METHODS_UPDATE = 'CUSTOMER_PAYMENT_METHODS_UPDATE';
    public const CUSTOMER_TAGS_ADDED = 'CUSTOMER_TAGS_ADDED';
    public const CUSTOMER_TAGS_REMOVED = 'CUSTOMER_TAGS_REMOVED';
    public const DISCOUNTS_CREATE = 'DISCOUNTS_CREATE';
    public const DISCOUNTS_DELETE = 'DISCOUNTS_DELETE';
    public const DISCOUNTS_REDEEMCODE_ADDED = 'DISCOUNTS_REDEEMCODE_ADDED';
    public const DISCOUNTS_REDEEMCODE_REMOVED = 'DISCOUNTS_REDEEMCODE_REMOVED';
    public const DISCOUNTS_UPDATE = 'DISCOUNTS_UPDATE';
    public const DISPUTES_CREATE = 'DISPUTES_CREATE';
    public const DISPUTES_UPDATE = 'DISPUTES_UPDATE';
    public const DOMAINS_CREATE = 'DOMAINS_CREATE';
    public const DOMAINS_DESTROY = 'DOMAINS_DESTROY';
    public const DOMAINS_UPDATE = 'DOMAINS_UPDATE';
    public const DRAFT_ORDERS_CREATE = 'DRAFT_ORDERS_CREATE';
    public const DRAFT_ORDERS_DELETE = 'DRAFT_ORDERS_DELETE';
    public const DRAFT_ORDERS_UPDATE = 'DRAFT_ORDERS_UPDATE';
    public const FULFILLMENTS_CREATE = 'FULFILLMENTS_CREATE';
    public const FULFILLMENTS_UPDATE = 'FULFILLMENTS_UPDATE';
    public const FULFILLMENT_EVENTS_CREATE = 'FULFILLMENT_EVENTS_CREATE';
    public const FULFILLMENT_EVENTS_DELETE = 'FULFILLMENT_EVENTS_DELETE';
    public const FULFILLMENT_ORDERS_CANCELLATION_REQUEST_ACCEPTED = 'FULFILLMENT_ORDERS_CANCELLATION_REQUEST_ACCEPTED';
    public const FULFILLMENT_ORDERS_CANCELLATION_REQUEST_REJECTED = 'FULFILLMENT_ORDERS_CANCELLATION_REQUEST_REJECTED';
    public const FULFILLMENT_ORDERS_CANCELLATION_REQUEST_SUBMITTED =
        'FULFILLMENT_ORDERS_CANCELLATION_REQUEST_SUBMITTED';
    public const FULFILLMENT_ORDERS_CANCELLED = 'FULFILLMENT_ORDERS_CANCELLED';
    public const FULFILLMENT_ORDERS_FULFILLMENT_REQUEST_ACCEPTED = 'FULFILLMENT_ORDERS_FULFILLMENT_REQUEST_ACCEPTED';
    public const FULFILLMENT_ORDERS_FULFILLMENT_REQUEST_REJECTED = 'FULFILLMENT_ORDERS_FULFILLMENT_REQUEST_REJECTED';
    public const FULFILLMENT_ORDERS_FULFILLMENT_REQUEST_SUBMITTED = 'FULFILLMENT_ORDERS_FULFILLMENT_REQUEST_SUBMITTED';
    public const FULFILLMENT_ORDERS_FULFILLMENT_SERVICE_FAILED_TO_COMPLETE =
        'FULFILLMENT_ORDERS_FULFILLMENT_SERVICE_FAILED_TO_COMPLETE';
    public const FULFILLMENT_ORDERS_LINE_ITEMS_PREPARED_FOR_LOCAL_DELIVERY =
        'FULFILLMENT_ORDERS_LINE_ITEMS_PREPARED_FOR_LOCAL_DELIVERY';
    public const FULFILLMENT_ORDERS_LINE_ITEMS_PREPARED_FOR_PICKUP =
        'FULFILLMENT_ORDERS_LINE_ITEMS_PREPARED_FOR_PICKUP';
    public const FULFILLMENT_ORDERS_MERGED = 'FULFILLMENT_ORDERS_MERGED';
    public const FULFILLMENT_ORDERS_MOVED = 'FULFILLMENT_ORDERS_MOVED';
    public const FULFILLMENT_ORDERS_ORDER_ROUTING_COMPLETE = 'FULFILLMENT_ORDERS_ORDER_ROUTING_COMPLETE';
    public const FULFILLMENT_ORDERS_PLACED_ON_HOLD = 'FULFILLMENT_ORDERS_PLACED_ON_HOLD';
    public const FULFILLMENT_ORDERS_RESCHEDULED = 'FULFILLMENT_ORDERS_RESCHEDULED';
    public const FULFILLMENT_ORDERS_SCHEDULED_FULFILLMENT_ORDER_READY =
        'FULFILLMENT_ORDERS_SCHEDULED_FULFILLMENT_ORDER_READY';
    public const FULFILLMENT_ORDERS_SPLIT = 'FULFILLMENT_ORDERS_SPLIT';
    public const INVENTORY_ITEMS_CREATE = 'INVENTORY_ITEMS_CREATE';
    public const INVENTORY_ITEMS_DELETE = 'INVENTORY_ITEMS_DELETE';
    public const INVENTORY_ITEMS_UPDATE = 'INVENTORY_ITEMS_UPDATE';
    public const INVENTORY_LEVELS_CONNECT = 'INVENTORY_LEVELS_CONNECT';
    public const INVENTORY_LEVELS_DISCONNECT = 'INVENTORY_LEVELS_DISCONNECT';
    public const INVENTORY_LEVELS_UPDATE = 'INVENTORY_LEVELS_UPDATE';
    public const LOCALES_CREATE = 'LOCALES_CREATE';
    public const LOCALES_UPDATE = 'LOCALES_UPDATE';
    public const LOCATIONS_ACTIVATE = 'LOCATIONS_ACTIVATE';
    public const LOCATIONS_CREATE = 'LOCATIONS_CREATE';
    public const LOCATIONS_DEACTIVATE = 'LOCATIONS_DEACTIVATE';
    public const LOCATIONS_DELETE = 'LOCATIONS_DELETE';
    public const LOCATIONS_UPDATE = 'LOCATIONS_UPDATE';
    public const MARKETS_CREATE = 'MARKETS_CREATE';
    public const MARKETS_DELETE = 'MARKETS_DELETE';
    public const MARKETS_UPDATE = 'MARKETS_UPDATE';
    public const METAOBJECTS_CREATE = 'METAOBJECTS_CREATE';
    public const METAOBJECTS_DELETE = 'METAOBJECTS_DELETE';
    public const METAOBJECTS_UPDATE = 'METAOBJECTS_UPDATE';
    public const ORDERS_CANCELLED = 'ORDERS_CANCELLED';
    public const ORDERS_CREATE = 'ORDERS_CREATE';
    public const ORDERS_DELETE = 'ORDERS_DELETE';
    public const ORDERS_EDITED = 'ORDERS_EDITED';
    public const ORDERS_FULFILLED = 'ORDERS_FULFILLED';
    public const ORDERS_PAID = 'ORDERS_PAID';
    public const ORDERS_PARTIALLY_FULFILLED = 'ORDERS_PARTIALLY_FULFILLED';
    public const ORDERS_RISK_ASSESSMENT_CHANGED = 'ORDERS_RISK_ASSESSMENT_CHANGED';
    public const ORDERS_SHOPIFY_PROTECT_ELIGIBILITY_CHANGED = 'ORDERS_SHOPIFY_PROTECT_ELIGIBILITY_CHANGED';
    public const ORDERS_UPDATED = 'ORDERS_UPDATED';
    public const ORDER_TRANSACTIONS_CREATE = 'ORDER_TRANSACTIONS_CREATE';
    public const PAYMENT_SCHEDULES_DUE = 'PAYMENT_SCHEDULES_DUE';
    public const PAYMENT_TERMS_CREATE = 'PAYMENT_TERMS_CREATE';
    public const PAYMENT_TERMS_DELETE = 'PAYMENT_TERMS_DELETE';
    public const PAYMENT_TERMS_UPDATE = 'PAYMENT_TERMS_UPDATE';
    public const PRODUCTS_CREATE = 'PRODUCTS_CREATE';
    public const PRODUCTS_DELETE = 'PRODUCTS_DELETE';
    public const PRODUCTS_UPDATE = 'PRODUCTS_UPDATE';
    public const PRODUCT_FEEDS_CREATE = 'PRODUCT_FEEDS_CREATE';
    public const PRODUCT_FEEDS_FULL_SYNC = 'PRODUCT_FEEDS_FULL_SYNC';
    public const PRODUCT_FEEDS_FULL_SYNC_FINISH = 'PRODUCT_FEEDS_FULL_SYNC_FINISH';
    public const PRODUCT_FEEDS_INCREMENTAL_SYNC = 'PRODUCT_FEEDS_INCREMENTAL_SYNC';
    public const PRODUCT_FEEDS_UPDATE = 'PRODUCT_FEEDS_UPDATE';
    public const PRODUCT_LISTINGS_ADD = 'PRODUCT_LISTINGS_ADD';
    public const PRODUCT_LISTINGS_REMOVE = 'PRODUCT_LISTINGS_REMOVE';
    public const PRODUCT_LISTINGS_UPDATE = 'PRODUCT_LISTINGS_UPDATE';
    public const PRODUCT_PUBLICATIONS_CREATE = 'PRODUCT_PUBLICATIONS_CREATE';
    public const PRODUCT_PUBLICATIONS_DELETE = 'PRODUCT_PUBLICATIONS_DELETE';
    public const PRODUCT_PUBLICATIONS_UPDATE = 'PRODUCT_PUBLICATIONS_UPDATE';
    public const PROFILES_CREATE = 'PROFILES_CREATE';
    public const PROFILES_DELETE = 'PROFILES_DELETE';
    public const PROFILES_UPDATE = 'PROFILES_UPDATE';
    public const PUBLICATIONS_DELETE = 'PUBLICATIONS_DELETE';
    public const REFUNDS_CREATE = 'REFUNDS_CREATE';
    public const RETURNS_APPROVE = 'RETURNS_APPROVE';
    public const RETURNS_CANCEL = 'RETURNS_CANCEL';
    public const RETURNS_CLOSE = 'RETURNS_CLOSE';
    public const RETURNS_DECLINE = 'RETURNS_DECLINE';
    public const RETURNS_REOPEN = 'RETURNS_REOPEN';
    public const RETURNS_REQUEST = 'RETURNS_REQUEST';
    public const RETURNS_UPDATE = 'RETURNS_UPDATE';
    public const REVERSE_DELIVERIES_ATTACH_DELIVERABLE = 'REVERSE_DELIVERIES_ATTACH_DELIVERABLE';
    public const REVERSE_FULFILLMENT_ORDERS_DISPOSE = 'REVERSE_FULFILLMENT_ORDERS_DISPOSE';
    public const SCHEDULED_PRODUCT_LISTINGS_ADD = 'SCHEDULED_PRODUCT_LISTINGS_ADD';
    public const SCHEDULED_PRODUCT_LISTINGS_REMOVE = 'SCHEDULED_PRODUCT_LISTINGS_REMOVE';
    public const SCHEDULED_PRODUCT_LISTINGS_UPDATE = 'SCHEDULED_PRODUCT_LISTINGS_UPDATE';
    public const SEGMENTS_CREATE = 'SEGMENTS_CREATE';
    public const SEGMENTS_DELETE = 'SEGMENTS_DELETE';
    public const SEGMENTS_UPDATE = 'SEGMENTS_UPDATE';
    public const SELLING_PLAN_GROUPS_CREATE = 'SELLING_PLAN_GROUPS_CREATE';
    public const SELLING_PLAN_GROUPS_DELETE = 'SELLING_PLAN_GROUPS_DELETE';
    public const SELLING_PLAN_GROUPS_UPDATE = 'SELLING_PLAN_GROUPS_UPDATE';
    public const SHIPPING_ADDRESSES_CREATE = 'SHIPPING_ADDRESSES_CREATE';
    public const SHIPPING_ADDRESSES_UPDATE = 'SHIPPING_ADDRESSES_UPDATE';
    public const SHOP_UPDATE = 'SHOP_UPDATE';
    public const SUBSCRIPTION_BILLING_ATTEMPTS_CHALLENGED = 'SUBSCRIPTION_BILLING_ATTEMPTS_CHALLENGED';
    public const SUBSCRIPTION_BILLING_ATTEMPTS_FAILURE = 'SUBSCRIPTION_BILLING_ATTEMPTS_FAILURE';
    public const SUBSCRIPTION_BILLING_ATTEMPTS_SUCCESS = 'SUBSCRIPTION_BILLING_ATTEMPTS_SUCCESS';
    public const SUBSCRIPTION_BILLING_CYCLES_SKIP = 'SUBSCRIPTION_BILLING_CYCLES_SKIP';
    public const SUBSCRIPTION_BILLING_CYCLES_UNSKIP = 'SUBSCRIPTION_BILLING_CYCLES_UNSKIP';
    public const SUBSCRIPTION_BILLING_CYCLE_EDITS_CREATE = 'SUBSCRIPTION_BILLING_CYCLE_EDITS_CREATE';
    public const SUBSCRIPTION_BILLING_CYCLE_EDITS_DELETE = 'SUBSCRIPTION_BILLING_CYCLE_EDITS_DELETE';
    public const SUBSCRIPTION_BILLING_CYCLE_EDITS_UPDATE = 'SUBSCRIPTION_BILLING_CYCLE_EDITS_UPDATE';
    public const SUBSCRIPTION_CONTRACTS_ACTIVATE = 'SUBSCRIPTION_CONTRACTS_ACTIVATE';
    public const SUBSCRIPTION_CONTRACTS_CANCEL = 'SUBSCRIPTION_CONTRACTS_CANCEL';
    public const SUBSCRIPTION_CONTRACTS_EXPIRE = 'SUBSCRIPTION_CONTRACTS_EXPIRE';
    public const SUBSCRIPTION_CONTRACTS_FAIL = 'SUBSCRIPTION_CONTRACTS_FAIL';
    public const SUBSCRIPTION_CONTRACTS_PAUSE = 'SUBSCRIPTION_CONTRACTS_PAUSE';
    public const SUBSCRIPTION_CONTRACTS_CREATE = 'SUBSCRIPTION_CONTRACTS_CREATE';
    public const SUBSCRIPTION_CONTRACTS_UPDATE = 'SUBSCRIPTION_CONTRACTS_UPDATE';
    public const TAX_PARTNERS_UPDATE = 'TAX_PARTNERS_UPDATE';
    public const TAX_SERVICES_CREATE = 'TAX_SERVICES_CREATE';
    public const TAX_SERVICES_UPDATE = 'TAX_SERVICES_UPDATE';
    public const TENDER_TRANSACTIONS_CREATE = 'TENDER_TRANSACTIONS_CREATE';
    public const THEMES_CREATE = 'THEMES_CREATE';
    public const THEMES_DELETE = 'THEMES_DELETE';
    public const THEMES_PUBLISH = 'THEMES_PUBLISH';
    public const THEMES_UPDATE = 'THEMES_UPDATE';
    public const VARIANTS_IN_STOCK = 'VARIANTS_IN_STOCK';
    public const VARIANTS_OUT_OF_STOCK = 'VARIANTS_OUT_OF_STOCK';
}
